unit VCType32;{Feb14/97 9:30am}{Aug 12/99 BRM}

interface

uses WinTypes;

Type
iPoint2D=record
  x: Longint;
  y: Longint;
end;

Type
fPoint2D=record
  x: smallint;
  y: smallint;
end;

Type
Point2D = record
  x: Double;
  y: Double;
end;

Type
lPoint2D=record
  x: Longint;
  y: Longint;
end;

Type
Point3D=record
  x: Double;
  y: Double;
  z: Double;
end;

Type
EAttr=record
  color: smallint;
  layer: smallint;
  linetype: smallint;
  linewidth: smallint;
  fWidth: Single;
  bByLayerFlag: Byte;
end;

Type
Rect=record
  top: Double;
  bottom: Double;
  left: Double;
  right: Double;
end;

{Visual CADD Global Global Constants}


{Entity Kinds}
Const
entUNKNOWN = 0;
entLINE2D = 1;
entARC2D = 2;
entCIRCLE2D = 3;
entELLIPSE2D = 4;
entBEZIER2D = 5;
entPOINT2D = 6;
entSYMBOL2D = 7;
entTEXT2D = 8;
entDIMLINEAR2D = 9;
entDIMANGULAR2D = 10;
entDIMRADIAL2D = 11;
entDIMDIAMETER2D = 12;
entFILL2D = 13;
entHATCH2D = 14;
entATTRIBUTE2D = 15;
entINTERPCURV2D = 16;
entMINTERPCURV2D = 17;
entELLIPTICALARC2D = 18;
entCONTINUOUSLINE2D = 19;
entCONTINUOUSBEZIER2D = 20;
entLEADER2D = 21;
entREFFRAME2D = 22;
entORDDIM2D = 23;
entPOLYGON3D = 101;
entPOINT3D = 102;
entLINE3D = 103;
entSYMBOL3D = 104;
entCONTINUOUSLINE3D = 105;

{ VC Supported File Types}

Const
FILE_VCD = 0;
FILE_VCS = 1;
FILE_VCA = 2;
FILE_GCD = 3;
FILE_CMP = 4;
FILE_DWG = 5;
FILE_DXF = 6;
FILE_STY = 7;
FILE_VCF = 8;
FILE_EMF = 9;
FILE_WMF = 10;

{ Conversion Unit Constants}
Const
UNIT_INCH = 0;
UNIT_FEET = 1;
UNIT_MM = 2;
UNIT_CM = 3;
UNIT_M = 4;
UNIT_MILE = 10;
UNIT_K = 11;

{ Autocad Import Unit Types}
Const 
ACAD_UNIT_INCH = 0;
ACAD_UNIT_FEET = 1;
ACAD_UNIT_MILL = 2;
ACAD_UNIT_CENT = 3;
ACAD_UNIT_METER = 4;

{ Return values for VCGetCurrentEntityUserDataKind() }
UID_BYTE = 1;
UID_SHORT = 2;
UID_LONG = 3;
UID_DOUBLE = 4;
UID_FLOAT = 5;
UID_CHUNK = 6;

{ Display Unit}
InDec = 0;
FtInDec = 1;
FtDec = 2;
InFrac = 3;
FtInFrac = 4;
FtFrac = 5;
Mil = 6;
Cen = 7;
Met = 8;
AngDeg = 9;
AngDMS = 10;
Mile = 20;
Kilo = 21;

{ Dimension Mode}
Const
DIMMODESINGLE = 0;
DIMMODECUMULATIVE = 1;
DIMMODEPARTITIONED = 2;

{ Dimension Direction}
Const
DIMALIGNED = 1;
DIMHORIZONTAL = 2;
DIMVERTICAL = 3;
DIMATANANGLE = 4;

{ Dimension Tolerance Type}
Const
DIMNOTOLERANCE = 0;
DIMSTACKEDMINMAX = 1;
DIMSTACKEDVARIANCE = 2;
DIMFIXEDVARIANCE = 3;

{ Dimension Extension Line}
Const
DIMEXTNOSTRETCH = 0;
DIMEXTSTRETCH = 1;

{ Dimension Unit Type (Linear, Radial, or Diameter Dimensions)}
Const
DIMINCHES = 1;
DIMFEET = 2;
DIMMETERS = 3;
DIMMILLIMETERS = 4;
DIMCENTIMETERS = 5;
DIMFTIN = 6;

{ Dimension Unit Type (Angular Dimensions)}
Const
DIMANGLEFORMATDECIMAL = 0;
DIMANGLEFORMATMINUTES = 1;

{ Dimension Arrow Types}
Const
DIMARROWREGNOFILL = 0;
DIMARROWREGFILLED = 1;
DIMARROWREGOPEN = 2;
DIMARROWNOTCHED = 3;
DIMARROWSLASH = 4;
DIMARROWCIRCLENOFILL = 5;
DIMARROWCIRCLEFILL = 6;

{ Dimension Text}
Const
DIMTEXTINLINE = 0;
DIMTEXTABOVELINE = 1;
DIMTEXTFREEFLOAT = 2;

{ Dimension Text Rotation}
Const
DIMTEXTROTATIONALIGNED = 0;
DIMTEXTROTATIONHORIZONTAL = 1;

{ Linear Dimension Line Position}
Const
DIMLINELEFT = 0;
DIMLINERIGHT = 1;

{ Dimension Proximity Mode}
Const
DIMLINENOPROXFIX = 0;
DIMLINEPROXFIX = 1;

{ Dimension Arrow Mode}
Const
DIMARROWNOFLIP = 0;
DIMARROWFLIP = 1;

{ Dimension items}
Const 
DIMLINE = 0;
DIMLEFTARROW = 1;
DIMRIGHTARROW = 2;
DIMLEFTEXT = 3;
DIMRIGHTEXT = 4;
DIMTEXT = 5;

{ Datum modes}
Const 
DATUMNONE = 0;
DATUMXY = 1;
DATUMX = 2;
DATUMY = 3;

{ Justify modes}
Const 
JUSTIFY_CENTER = 67;
JUSTIFY_LEFT = 76;
JUSTIFY_RIGHT = 82;

{ VCAlertApp Codes}
Const
ALERT_APP_ALL =	0;
ALERT_APP_UTOOL_MOUSEDOWN =1;
ALERT_APP_UTOOL_MOUSEDOWN_DLL ='MouseDown';
ALERT_APP_UTOOL_MOUSEMOVE =2;
ALERT_APP_UTOOL_MOUSEMOVE_DLL ='MouseMove';
ALERT_APP_UTOOL_ABORT= 4;
ALERT_APP_UTOOL_ABORT_DLL= 'Abort';
ALERT_APP_CMDLINE_CHAR =8;
ALERT_APP_CMDLINE_CHAR_DLL ='Char';
ALERT_APP_CLOSE =16;
ALERT_APP_CLOSE_DLL ='AppClose';
ALERT_APP_UTOOL_PENUP =32;	
ALERT_APP_UTOOL_PENUP_DLL= 'PenUp';
ALERT_PENUP_CHARCODE =252;										 
ALERT_APP_WORLD_CLOSE=	64;
ALERT_APP_WORLD_CLOSE_DLL=	'DrawingClose';
ALERT_WORLD_CLOSE_CHARCODE= 253;
ALERT_APP_UTOOL_ERASERUBBER =128;	
ALERT_APP_UTOOL_ERASERUBBER_DLL ='EraseRubber';
ALERT_UTOOL_ERASERUBBER_CHARCODE =255;
ALERT_APP_TOOL_COMPLETE =256; 
ALERT_APP_TOOL_COMPLETE_DLL ='ToolComplete';
ALERT_TOOL_COMPLETE_CHARCODE =254;
ALERT_APP_UTOOL_INIT =512;
ALERT_APP_UTOOL_INIT_DLL= 'Init';
ALERT_UTOOL_INIT_CHARCODE= 251;
ALERT_APP_UTOOL_TERMINATE =1024;
ALERT_APP_UTOOL_TERMINATE_DLL= 'Terminate';
ALERT_UTOOL_TERMINATE_CHARCODE= 250;
ALERT_APP_FRAME_CLOSE =2048;
ALERT_APP_FRAME_CLOSE_DLL ='FrameClose';
ALERT_FRAME_CLOSE_CHARCODE =249;
ALERT_APP_FRAME_RESIZE =4096;
ALERT_APP_FRAME_RESIZE_DLL= 'FrameResise';
ALERT_FRAME_RESIZE_CHARCODE =248;
ALERT_APP_ENTITY_ERASED= 8192;
ALERT_APP_ENTITY_ERASED_DLL ='EntityErased';
ALERT_APP_ENTITY_ERASED_CHARCODE= 247;
ALERT_APP_ENTITY_SELECT_CHANGE= 16384;
ALERT_APP_ENTITY_SELECT_CHANGE_DLL ='EntitySelectChange';
ALERT_APP_ENTITY_SELECT_CHANGE_CHARCODE =246;
ALERT_APP_ACTIVATE =32768;
ALERT_APP_ACTIVATE_DLL ='Activate';
ALERT_APP_ACTIVATE_CHARCODE =245;
ALERT_APP_DEACTIVATE =65536;
ALERT_APP_DEACTIVATE_DLL= 'DeActivate';
ALERT_APP_DEACTIVATE_CHARCODE =244;

ALERT_APP_UTOOL_MOUSEUP =131072;
ALERT_APP_UTOOL_MOUSEUP_DLL= 'MouseUp';

ALERT_APP_WORLD_MOUSEMOVE = 262144;
ALERT_APP_WORLD_MOUSEMOVE_DLL = 'WorldMouseMove';
ALERT_APP_WORLD_MOUSEMOVE_CHARCODE = 243;

ALERT_APP_WORLD_MOUSEDOWN = 524288;
ALERT_APP_WORLD_MOUSEDOWN_DLL = 'WorldMouseDown';
ALERT_APP_WORLD_MOUSEDOWN_CHARCODE = 242;

ALERT_APP_WORLD_MOUSEUP = 1048576;
ALERT_APP_WORLD_MOUSEUP_DLL = 'WorldMouseUp';
ALERT_APP_WORLD_MOUSEUP_CHARCODE = 241;

ALERT_APP_WORLD_END_REDRAW = 2097152;
ALERT_APP_WORLD_END_REDRAW_DLL = 'WorldEndRedraw';
ALERT_APP_WORLD_END_REDRAW_CHARCODE = 240;

ALERT_APP_WORLD_BEGIN_REDRAW = 4194304;
ALERT_APP_WORLD_BEGIN_REDRAW_DLL = 'WorldBeginRedraw';
ALERT_APP_WORLD_BEGIN_REDRAW_CHARCODE = 239;

ALERT_APP_WORLD_BEGIN_PRINT = 8388608;
ALERT_APP_WORLD_BEGIN_PRINT_DLL = 'WorldBeginPrint';
ALERT_APP_WORLD_BEGIN_PRINT_CHARCODE = 238;

ALERT_APP_WORLD_END_PRINT = 16777216;
ALERT_APP_WORLD_END_PRINT_DLL = 'WorldEndPrint';
ALERT_APP_WORLD_END_PRINT_CHARCODE = 237;

ALERT_APP_TOOL_START = 33554432;
ALERT_APP_TOOL_START_DLL = 'ToolStart';
ALERT_APP_TOOL_START_CHARCODE = 236;

ALERT_APP_TOOL_ABORT = 67108864;
ALERT_APP_TOOL_ABORT_DLL = 'ToolAbort';
ALERT_APP_TOOL_ABORT_CHARCODE = 235;


{ Defines for VCSetAlertAppEx & VCSetAlertAppDllEx iCode1 Parameter}
Const 
ALERT_APP_EX_ALL = $FFFFFFFF;
ALERT_APP_EX_PRE_TRANSLATE_GET_MESSAGE = $1;
ALERT_APP_EX_PRE_TRANSLATE_GET_MESSAGE_DLL = 'PreTranslateGetMessage';
ALERT_APP_EX_PRE_TRANSLATE_GET_MESSAGE_CHARCODE = 233;

ALERT_APP_EX_PRE_TRANSLATE_FRAME_MESSAGE = $2;
ALERT_APP_EX_PRE_TRANSLATE_FRAME_MESSAGE_DLL = 'PreTranslateFrameMessage';
ALERT_APP_EX_PRE_TRANSLATE_FRAME_MESSAGE_CHARCODE = 232;

ALERT_APP_EX_PRE_TRANSLATE_DIALOG_MESSAGE = $4;
ALERT_APP_EX_PRE_TRANSLATE_DIALOG_MESSAGE_DLL = 'PreTranslateDialogMessage';
ALERT_APP_EX_PRE_TRANSLATE_DIALOG_MESSAGE_CHARCODE = 231;

{ VCM_USER_ALERT Posted as the wParam of a WM_COMMAND Message will cause Visual Cadd
  to call the ALERT_APP_EX_USER_ALERT_MESSAGE.  The lParam the user sends in the WM_COMMAND
  message will be sent back to them.  This call can be used to avoid recursion which can
  happen in many of the AlertApp messages such as starting a new tool from within the
  AlertAppToolComplete message.
}
Const 
ALERT_APP_EX_USER_ALERT_MESSAGE = $8;
ALERT_APP_EX_USER_ALERT_DLL = 'UserAlert';
ALERT_APP_EX_USER_ALERT_CHARCODE = 230;
VCM_USER_ALERT = 2801;

ALERT_APP_EX_DIALOG_OPEN_MESSAGE = $10;
ALERT_APP_EX_DIALOG_OPEN_DLL = 'DialogOpen';
ALERT_APP_EX_DIALOG_OPEN_CHARCODE = 229;

ALERT_APP_EX_DIALOG_CLOSE_MESSAGE = $20;
ALERT_APP_EX_DIALOG_CLOSE_DLL = 'DialogClose';
ALERT_APP_EX_DIALOG_CLOSE_CHARCODE = 228;

{ API calls which use 'SymbolIndex', use this parameter for entity section additions}
Const
NONDEFENTITY = -1;
HATCHFILLENTITY = -2;

{ VCSetProjection3D Codes}
Const
VIEW3D_FLAT = 0;
VIEW3D_PARALLEL = 1;
VIEW3D_PERSPECTIVE = 2;

{ VCSet3DDisplay Codes}
Const
VIEW3D_WIREFRAME = 0;
VIEW3D_QSHADE = 1;

{ VCSetView3DQShadeOptions}
Const
QSHADE_ROUGH = 0;
QSHADE_EXACT = 1;
QSHADE_EXACT_AND_SPLIT = 2;

{ VCChangeView3D Codes}
Const
CHANGE_VIEW3D_LEFT = 0;
CHANGE_VIEW3D_RIGHT = 1;
CHANGE_VIEW3D_UP = 2;
CHANGE_VIEW3D_DOWN = 3;

{ Printer/Plotter definitions }
PrintMode = 0;
PLOTMODE = 1;

FITTOPAPER = 0;
CURRENTVIEW = 1;
USERSCALE = 2;

PORTRAITMODE = 0;
LANDSCAPEMODE = 1;

METRICUNITS = 0;
ENGLISHUNITS = 1;

PORTCOM1 = 0;
PORTCOM2 = 1;
PORTCOM3 = 2;
PORTCOM4 = 3;
PORTLPT1 = 4;
PORTLPT2 = 5;
PORTLPT3 = 6;
PORTFILE = 7;

BAUD110 = 0;
BAUD300 = 1;
BAUD1200 = 2;
BAUD2400 = 3;
BAUD4800 = 4;
BAUD9600 = 5;
BAUD19200 = 6;
BAUD38400 = 7;
BAUD57600 = 8;

DATABITS7 = 0;
DATABITS8 = 1;

PARITYODD = 0;
PARITYEVEN = 1;
PARITYNONE = 2;

STOPBITS1 = 0;
STOPBITS2 = 1;

Type
PrintStruct=record
		PrintMode: wordbool;
		PageSize: Point2D;
		Margins: Rect;
		dScale: Double;
		Origin: Point2D;
		ScaleMode: smallint;
		Orientation: smallint;
		dRotation: Double;
		PrintToFile: wordbool;
		SelectionOnly: wordbool;
		DateStamp: wordbool;
		FastPreview: wordbool;
		AllColorsToBlack: wordbool;
		PaperUnit: smallint;
end;

Type
PlotStruct=record
		Port: smallint;
		BaudRate: smallint;
		DataBits: smallint;
		Parity: smallint;
		StopBits: smallint;
		NumPens: smallint;
		NumCarousels: smallint;
		DPI: smallint;
		UseCarousels: wordbool;
		UseLLOrigin: wordbool;
		SortColors: wordbool;
		Optimize: wordbool;
		BufferOutput: wordbool;
end;

{ VCGetToolbar constants}
Const 
TBNONE = 0;   { no toolbar}
TBTOP = 1;    { the main speedbar}
TBLEFT = 2;   { the tool palette}
TBRIGHT = 3;  { not used}
TBBOTTOM = 4; { the status bar}

implementation

end.
